// PingSetupDlg.cpp : implementation file
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "PingSetupDlg.h"
#include "PingGlobals.h"
/////////////////////////////////////////////////////////////////////////////
// CPingSetupDlg dialog
/////////////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNAMIC(CPingSetupDlg, CDialog)
/////////////////////////////////////////////////////////////////////////////
CPingSetupDlg::CPingSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPingSetupDlg::IDD, pParent)
	, m_strAddr(_T(""))
{
	m_hBrush = NULL;
}
/////////////////////////////////////////////////////////////////////////////
CPingSetupDlg::~CPingSetupDlg()
{
}
/////////////////////////////////////////////////////////////////////////////
void CPingSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_ADDR_EDIT, m_strAddr);
}
/////////////////////////////////////////////////////////////////////////////
BEGIN_MESSAGE_MAP(CPingSetupDlg, CDialog)
	ON_WM_CTLCOLOR()
	ON_WM_DESTROY()
END_MESSAGE_MAP()
/////////////////////////////////////////////////////////////////////////////
// CPingSetupDlg message handlers
/////////////////////////////////////////////////////////////////////////////
LPCSTR CPingSetupDlg::GetAddr()
{
	return m_strAddr;
}
/////////////////////////////////////////////////////////////////////////////
void CPingSetupDlg::SetAddr(LPCSTR lpAddr)
{
	m_strAddr = lpAddr;
}
/////////////////////////////////////////////////////////////////////////////
void CPingSetupDlg::OnDestroy()
{
	if (m_hBrush)
	{
		DeleteObject(m_hBrush);

		m_hBrush = NULL;
	}

	CDialog::OnDestroy();
}
/////////////////////////////////////////////////////////////////////////////
HBRUSH CPingSetupDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	COLORREF clrBk		= g_dwHeaderBgndColor;
	COLORREF clrText	= g_dwHeaderTextColor;

	UINT nID			= pWnd->GetDlgCtrlID();

	if (nID == IDC_ADDR_PROPERTIES_HEADER)
	{
		if (!m_hBrush)
 			m_hBrush = CreateSolidBrush(clrBk);

		pDC->SetBkColor(clrBk);
		pDC->SetTextColor(clrText);
	}
	else 
		return CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	return m_hBrush;
}
/////////////////////////////////////////////////////////////////////////////
BOOL CPingSetupDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	LocalizeWnd(m_hWnd);
	AdjustWindowPos(this, GetParent());

	return TRUE; 
}
/////////////////////////////////////////////////////////////////////////////
